/**
 * \file conv.h
 * @short Declaration of class Conv
 */

#ifndef _CONV_H_
#define _CONV_H_

#include <string>

/**
 * @short Static class with various conversions
 */
class Conv
{
  public:
    
    /**
     * Converts a frame number to time 
     *
     * Every frame lasts exactly mp3::frametime miliseconds.
     *
     * @param framenum Number of frame in stream
     * @return Frame time in format minutes:seconds.miliseconds
     */
    static std::string Frame2Time(int framenum);
    
    /**
     * Converts a time to frame number
     *
     * Every frame lasts exactly mp3::frametime miliseconds.
     *
     * @param ch Time in format minutes:seconds.miliseconds
     * @return Frame number
     */
    static int Time2Frame(const char *ch);
    
    /**
     * Converts dB to MP3 volume units
     *
     * 1.5dB equals one volume unit
     *
     * @param gainstr String with dB value 
     * @return Volume in MP3 units
     */
    static int dB2Gain(const char *gainstr);
    
    /**
     * Converts tag genre number to its name
     *
     * @param genre Number of genre, see Genres
     * @return Genre name
     */
    static std::string Num2Genre(int genre);
    
    /**
     * Find genre and return its number
     *
     * If the genre wasn't found, use genre "other"
     *
     * @param genrename Name of genre
     * @return Genre number 
     */
    static int Genre2Num(const char *genrename);
};

#endif //
