#ifndef _TETRIS_H
#define _TETRIS_H

#include <limits.h>

//Prikazy odpovidajici stisknute klavese
#define CMD_OTHER   0
#define CMD_LEFT    1
#define CMD_RIGHT   2
#define CMD_DOWN    3
#define CMD_RROT    4
#define CMD_LROT    5
#define CMD_FALL    6

//Moznosti hry
#define GAME_HUMAN  0 //Standardni hra
#define GAME_COMP   1 //Pocitac hraje sam
#define GAME_HELP   2 //Pocitac ukazuje, kam by kostku polozil
#define GAME_MATCH  3 //Hra cloveka proti pocitaci
#define GAME_NET    4 //Hra po siti

//Vyber kostky
#define BRSEL_RANDOM 0 //Nahodny vyber
#define BRSEL_BETTER 1 //Vyber vyhodnejsi kostky
#define BRSEL_WORSE  2 //Vyber mene vyhodne kostky

#define START_POS { 0, 4, 0 } //Pocatecni pozice kostky

#define COEF1 30 //Zaporne body za diru
#define COEF2 15 //Kladne body za vymazanou radu
#define COEF3 10 //Body za kazdou jednotku rozdilu vysek nad 2

typedef struct { int r, x, y; } T_COORD; //Souradnice a natoceni kostky
typedef struct { unsigned char x, y; } T_CART; //Souradnice ctverecku

//Udaje o jednom natoceni kostky
typedef struct { T_CART sq[4]; //Souradnice ctverecku kostky
                 unsigned char x1, y1, x2, y2; //Souradnice okraju kostky
                 unsigned char row_width[4]; //Sirka kostky v jednotlivych sloupcich
                 unsigned char col_height[4]; //Vysky jednotlivych sloupcu kostky
               } T_SHAPE; //Jedno natoceni kostky

//Cislo kostky, vsechna natoceni kostky a jejich pocet
typedef struct { int num, n_rot; T_SHAPE rot[4]; } T_BRICK;

//Statisticke udaje
typedef struct { int all_bricks; //Celkovy pocet dopadnutych kostek
                 int single_brick[7]; //Pocty jednotlivych dopadnutych kostek
                 int all_rows; //Pocet vymazanych rad
                 int rows_by_number[5]; //Pocty vymazani po ... radach
                 int qual; //Vyhodnost pocitacem vybrane pozice
               } T_STATS;

typedef unsigned char T_BOARD[12][25]; //Zaplnene ctverecky

//Udaje o hre (zaplneni pole, statistika apod.)
typedef struct { T_STATS stats; //Statisticke udaje
                 T_BOARD board; //Zaplnene ctverecky
                 int row_sq[25]; //Pocty CTVERecku v rade
                 int height[11]; //Vysky jednotlivych sloupcu
                 int first_changed; /* Prvni a posledni rada, */
                 int last_changed;  /* ktere se zmenily       */
                 int mode; //Typ hry
                 int player; //Cislo hrace (od 0!)
               } T_GAME;

//Vrati v C zvolenou pozici kostky BRICK, navratova hodnota je jeji vyhodnost
int find_pos(T_BRICK *brick, T_COORD *c, T_GAME *game);

//Posune kostku BRICK na souiradnicich C dle prikazu CMD, pokud se nebude
//prekryvat se zaplnenymi ctverecky v poli BOARD.
//Vraci 0: kostka dopadla, 1: kostka se neposunula, 2: kostka se posunula
int move_brick(int cmd, T_COORD *c, T_BRICK *brick, T_BOARD board);

//Polozi kostku SHAPE na souradnice C, aktualizuje statistiku STATS,
//vraci 1, pokud se kostku povedlo polozit, jinak 0 (zaplneno, konec)
int set_brick(T_SHAPE *shape, T_COORD *c, T_GAME *game);

//Nacte kostky ze vstupniho souboru do pole BRICKS, vraci, zda se to povedlo
int read_bricks(T_BRICK *bricks);

//Inicializace struktury GAME
void initialize(T_GAME *game);

//Vrati nove vybranou kostku a aktualizuje statistiku ve strukture GAME
T_BRICK *new_brick(T_BRICK *bricks, T_GAME *game);

//Nastaveni zpusob vyberu kostek (druhu a intenzity)
void set_bricksel_mode(int brsel_mode, int brsel_intens);

//Generovani nahodnych cisel (linearni kongruencni generator)
//Generuje cisla z intervalu 0..(max-1), max muze byt nejvyse 32768
unsigned int myrand(int max);

//Nastaveni pocatecni hodnoty nahodneho generatoru
void mysrand(unsigned long newseed);

#endif
