#!/bin/bash

VOLSTEP=2
MIXER="/usr/bin/amixer set"
RADTOOL="/usr/bin/radeontool"
export GOV=/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor

case "$3" in
# Contrast-- (works automagically)
00000023) : logger "Button: Contrast down"
;;
# Contrast++ (works automagically)
00000014) : logger "Button: Contrast up"
;;
# Backlight OFF (works automagically)
00000033) : logger "Button: Backlight OFF"
;;
# Backlight ON (works automagically)
00000034) : logger "Button: Backlight ON"
;;
# LCD/Monitor button
00000061) $RADTOOL dac on && $RADTOOL light on
;;
# LCD/Monitor button
00000062) $RADTOOL dac on && $RADTOOL light off
;;
# LCD/Monitor button
00000063) $RADTOOL dac off && $RADTOOL light on
;;
# Mute button
00000032) $MIXER Front toggle
;;
# Volume down button
00000031) $MIXER Front $VOLSTEP-
;;
# Volume up button
00000030) $MIXER Front $VOLSTEP+
;;
# Bluetooth ON (works automagically)
0000007d) logger "Bluetooth ON"
;;
# Bluetooth OFF (works automagically)
0000007e) logger "Bluetooth OFF"
;;
# "Internet" button (I use it to eject the cdrom)
00000051) eject cdrom
;;
# WiFi button
0000005d) /etc/acpi/actions/wifi.sh
;;
# Touchpad on/off
0000006b) /etc/acpi/actions/touchpad.sh
;;
# "Performance" button - lock session
0000005c) /etc/acpi/actions/lock.sh 
;;
# Adaptor off-line
00000057) echo -n powersave > $GOV
;;
# Adaptor on-line
00000058) echo -n conservative > $GOV
;;
# "CD Player" button - hibernate
0000004c) /etc/acpi/actions/suspend.sh disk
;;
*) logger "ACPI hotkey $3 is not defined"
;;
esac
